pathHandler('load');
databaseFileExport('ircamSpectralDB_NO_IDX.db', 'ircamSpectralDB', 'localhost', 'root', []);
DROP_Names = {'SpectralFlatness', 'SpectralFlatnessDimension', ...
    'SpectralCrest', 'SpectralCrestDimension', 'TimeFrame', ...
    'TimeFrameMean', 'TimeFrameStdDev', 'TimeFrameTString', ...
    'HarmonicSpectralVariationMean', 'HarmonicSpectralVariationStdDev', ...
    'HarmonicSpectralVariationTString', 'HarmonicSpectralVariation', ...   
    'NoiseSpectralVariationMean', 'NoiseSpectralVariationStdDev', ...
    'NoiseSpectralVariationTString', 'NoiseSpectralVariation', 'MelEnergy'};
TS_Indexes = {'TotalEnergy', 'HarmonicEnergy', 'NoiseEnergy', ...
    'EnergyEnvelope', 'FundamentalFrequency', 'Noisiness', ...
    'Inharmonicity', 'HarmonicSpectralCentroid', ...
    'HarmonicSpectralSpread', 'HarmonicSpectralSkewness', ...
    'NoiseSpectralCentroid', 'PerceptualSpectralCentroid', ...
    'NoiseSpectralSpread', 'NoiseSpectralSkewness', ...
    'PerceptualSpectralSpread', 'PerceptualSpectralSkewness', ...
    'Loudness', 'Sharpness', 'Spread', 'SpectralCentroid', ...
    'SpectralSpread', 'SpectralSkewness', 'SpectralVariation'};
SQL_Indexes = {'name', 'file', 'source', 'instrument', 'family', ...
    'playingStyle', 'dynamics', 'note', 'pitchClass', 'octave', ...
    'stringMute', 'brassMute', 'duration', 'TotalEnergyMean' ...
    'TotalEnergyStdDev', 'HarmonicEnergyMean', 'HarmonicEnergyStdDev', ...
    'NoiseEnergyMean', 'NoiseEnergyStdDev', 'EnergyEnvelopeMean', ...
    'EnergyEnvelopeStdDev', 'FluctuationStrength', 'Roughness', ...
    'FundamentalFrequencyMean', 'FundamentalFrequencyStdDev', ...
    'NoisinessMean', 'NoisinessStdDev', 'InharmonicityMean', ...
    'InharmonicityStdDev', 'HarmonicSpectralCentroidMean', ...
    'HarmonicSpectralCentroidStdDev', 'HarmonicSpectralSpreadMean', ...
    'HarmonicSpectralSpreadStdDev', 'HarmonicSpectralSkewnessMean', ...
    'HarmonicSpectralSkewnessStdDev', 'NoiseSpectralCentroidMean', ...
    'NoiseSpectralCentroidStdDev', 'NoiseSpectralSpreadMean', ...
    'NoiseSpectralSpreadStdDev', 'NoiseSpectralSkewnessMean', ...
    'NoiseSpectralSkewnessStdDev', 'PerceptualSpectralCentroidMean', ...
    'PerceptualSpectralCentroidStdDev', 'PerceptualSpectralSpreadMean', ...
    'PerceptualSpectralSpreadStdDev', 'PerceptualSpectralSkewnessMean', ...
    'PerceptualSpectralSkewnessStdDev', 'LoudnessMean', ...
    'LoudnessStdDev', 'SharpnessMean', 'SharpnessStdDev', 'SpreadMean', ...
    'SpreadStdDev', 'SpectralCentroidMean', 'SpectralCentroidStdDev', ...
    'SpectralSpreadMean', 'SpectralSpreadStdDev', ...
    'SpectralSkewnessMean', 'SpectralSkewnessStdDev', ...
    'SpectralVariationMean', 'SpectralVariationStdDev', ...
    'loudnessFactor', 'soundID'};
connecDB = connectLocal('root', '', 'ircamSpectralDB');

'CREATE Table Arrays SELECT PartialsFrequencyDimension, PartialsFrequency, PartialsAmplitudeDimension, PartialsAmplitude, PartialsMeanFrequencyDimension, PartialsMeanFrequency, PartialsMeanAmplitudeDimension, PartialsMeanAmplitude, PartialsEnergyDimension, PartialsEnergy, soundID from Sounds'
'ALTER Table Sounds MODIFY PartialsFrequency int(34)'
'ALTER Table Sounds MODIFY PartialsAmplitude int(34)'
'ALTER Table Sounds MODIFY PartialsMeanFrequency int(33)'
'ALTER Table Sounds MODIFY PartialsMeanAmplitude int(33)'
'ALTER Table Sounds MODIFY PartialsEnergy int(33)'


disp('* Getting rid of useless columns :');
for i = 1:length(DROP_Names)
    curName = DROP_Names{i};
    disp(['    - ' curName '.']);
    sqlQ = ['ALTER TABLE Sounds DROP COLUMN ' curName];
    data = exec(connecDB, sqlQ);
    disp(data.Message);
end
disp('* Creating SQL Indexes :');
for i = 1:length(SQL_Indexes)
    curName = SQL_Indexes{i};
    disp(['    - ' curName '.']);
    sqlQ = ['CREATE INDEX ' curName '_IDX ON Sounds(' curName ')'];
    data = exec(connecDB, sqlQ);
    disp(data.Message);
end
disp('* Constructing empty session');
tmpSession = OSession();
tmpSession.constructDefaultSession();
disp('* Constructing time series indexes :');
for i = 1:length(TS_Indexes)
    curName = TS_Indexes{i};
    disp(['    - ' curName '.']);
    index = constructIndexesFromDB(tmpSession.getKnowledge(), curName);
    save([userDir '/Library/Preferences/IRCAM/descriptorsIndexes/' descName '.save.mat'], 'index');
    index.removeAllSeries();
    save([userDir '/Library/Preferences/IRCAM/descriptorsIndexes/' descName '.mat'], 'index');
end
databaseFileExport('ircamSpectralDB.db', 'ircamSpectralDB', 'localhost', 'root', []);

%%
TS_Indexes = {'TotalEnergy', 'HarmonicEnergy', 'NoiseEnergy', ...
    'EnergyEnvelope', 'FundamentalFrequency', 'Noisiness', ...
    'Inharmonicity', 'HarmonicSpectralCentroid', ...
    'HarmonicSpectralSpread', 'HarmonicSpectralSkewness', ...
    'NoiseSpectralCentroid', 'PerceptualSpectralCentroid', ...
    'NoiseSpectralSpread', 'NoiseSpectralSkewness', ...
    'PerceptualSpectralSpread', 'PerceptualSpectralSkewness', ...
    'Loudness', 'Sharpness', 'Spread', 'SpectralCentroid', ...
    'SpectralSpread', 'SpectralSkewness', 'SpectralVariation'};
tmpSession = OSession();
tmpSession.constructDefaultSession();
userDir = getenv('HOME'); 
for i = 1:length(TS_Indexes)
    curName = TS_Indexes{i};
    index = constructIndexesFromDB(tmpSession.getKnowledge(), curName);
    save([userDir '/Library/Preferences/IRCAM/descriptorsIndexes/' curName '.save.mat'], 'index');
    index.removeAllSeries();
    save([userDir '/Library/Preferences/IRCAM/descriptorsIndexes/' curName '.mat'], 'index');
end
    