% OSC_GET_FILTERS_LIST - Return the list of available optimization
% criteria
%
% Usage: handles = osc_get_criteria_list(osc_message,handles)
%

function handles = osc_get_filters_list(osc_message,handles)
% Check that a session is opened
if isempty(handles.session)
    error('osc_get_criteria_list:UexpectedMessage', 'First open a session.');
end
% Get filters structure
sFilters = handles.session.getProduction().filtersSet;
fNames = fieldnames(sFilters);
% Build OSC message
message.path = '/filterslist';
% Add criteria to message data
for k = 1:length(fNames)
    if isa(sFilters.(fNames{k}), 'FiltersTemporal') || strcmp(fNames{k}, 'name') || strcmp(fNames{k}, 'file') || strcmp(fNames{k}, 'pitchClass') || strcmp(fNames{k}, 'playingStyle');
        continue;
    end
    message.data = {};
    message.tt = 'iss';
    message.data{1} = osc_message.data{1};
    message.data{2} = fNames{k};
    if isa(sFilters.(fNames{k}), 'FiltersSymbolic')
        message.data{3} = 'Symbolic';
        vals = unique(sFilters.(fNames{k}).includeList);
        if strcmp(fNames{k}, 'note')
            vals = {'A#1','A#2','A#3','A#4','A#5','A1','A2','A3',...
                'A4','A5','B1','B2','B3','B4','B5','C#1','C#2',...
                'C#3','C#4','C#5','C1','C2','C3','C4','C5',...
                'D#1','D#2','D#3','D#4','D#5','D1','D2','D3','D4',...
                'D5','E1','E2','E3','E4','E5','F#1','F#2','F#3',...
                'F#4','F1','F2','F3','F4','G#1',...
                'G#2','G#3','G#4','G1','G2','G3','G4'};
        end
        for v = 1:length(vals)
            message.tt = [ message.tt 's' ];
            if strcmp(fNames{k}, 'octave')
                message.data{v + 3} = num2str(vals{v});
            else
                message.data{v + 3} = vals{v};
            end
        end
    else
        message.data{3} = 'Spectral';
        vals = sFilters.(fNames{k}).filterRange;
        message.tt = [message.tt 'ff'];
        message.data{4} = vals(1);
        message.data{5} = vals(2);
    end
    disp(fNames{k});
    disp(message.tt);
    disp(message.data);
    % Add to OSC buffer
    flux{1} = message;
    % Send message
    osc_send(handles.osc.address,flux);
end