% pathHandler.m     : Add or remove source directories to the Matlab path.
%
% mode: 
%   - 'load'        : Add directories to path
%   - 'unload'      : Remove directories from path
%
function pathHandler(mode)

pathes = { ...
    'analysis/' ...
    'analysis/utils/' ...
    'analysis/sax/' ...
    'analysis/descriptor/' ...
    'analysis/sdif/' ...
    'analysis/logs/' ...
    'analysis/features/' ...
    'analysis/convert/' ...
    'constraints/' ...
    'constraints/filters/' ...
    'constraints/instrumentation/' ...
    'database/' ...
    'errors/' ...
    'export/' ...
    'features/' ...
    'knowledge/' ...
    'osc/' ...
    'osc/mex/' ...
    'osc/lib/' ...
    'production/' ...
    'representation/' ...
    'search/' ...
    'search/genetic/' ...
    'search/multiobjective/' ...
    'search/indexing/' ...
    'search/segmentation/' ...
    'session/' ...
    'session/reports/' ...
    'solution/' ...
    'target/' ... 
    'utils/' ...
    'utils/path/' ...
    };
root_dir = which('atoms.m');
root_dir = strrep(root_dir,'atoms.m','');
switch mode
    case 'load'
        cmd = 'addpath';
    case 'unload'
        cmd = 'rmpath';
    otherwise
        error([ mode ' : unknown path handling mode.']);
end
disp([cmd ' ' root_dir ]);
eval([cmd ' ' root_dir ])
for k = 1:length(pathes)
    disp([cmd ' ' root_dir pathes{k}]);
    eval([cmd ' ' root_dir pathes{k}])
end