function mtnotes = midi2mtnotes(mtmidi)

% MIDI2MTNOTES - Convert a MIDI note vector into a cell array of
% strings. Microtonic pitch is supported up to the 1/16 tone.
%
% Usage: mtnotes = midi2mtnotes(<mtmidi>)
%

if nargin < 1
    mtmidi = (0:1/8:127+7/8)';
end

% Set highest pitch to G9
mtmidi = mtmidi(mtmidi<=127);

% Microtonic note list
all_mt_notes = {
        'C-1'
    'C-1+1.16'
    'C-1+1.8'
    'C-1+3.16'
    'C-1+1.4'
    'C-1+5.16'
    'C-1+3.8'
    'C-1+7.16'
    'C#-1'
    'C#-1+1.16'
    'C#-1+1.8'
    'C#-1+3.16'
    'C#-1+1.4'
    'C#-1+5.16'
    'C#-1+3.8'
    'C#-1+7.16'
    'D-1'
    'D-1+1.16'
    'D-1+1.8'
    'D-1+3.16'
    'D-1+1.4'
    'D-1+5.16'
    'D-1+3.8'
    'D-1+7.16'
    'D#-1'
    'D#-1+1.16'
    'D#-1+1.8'
    'D#-1+3.16'
    'D#-1+1.4'
    'D#-1+5.16'
    'D#-1+3.8'
    'D#-1+7.16'
    'E-1'
    'E-1+1.16'
    'E-1+1.8'
    'E-1+3.16'
    'E-1+1.4'
    'E-1+5.16'
    'E-1+3.8'
    'E-1+7.16'
    'F-1'
    'F-1+1.16'
    'F-1+1.8'
    'F-1+3.16'
    'F-1+1.4'
    'F-1+5.16'
    'F-1+3.8'
    'F-1+7.16'
    'F#-1'
    'F#-1+1.16'
    'F#-1+1.8'
    'F#-1+3.16'
    'F#-1+1.4'
    'F#-1+5.16'
    'F#-1+3.8'
    'F#-1+7.16'
    'G-1'
    'G-1+1.16'
    'G-1+1.8'
    'G-1+3.16'
    'G-1+1.4'
    'G-1+5.16'
    'G-1+3.8'
    'G-1+7.16'
    'G#-1'
    'G#-1+1.16'
    'G#-1+1.8'
    'G#-1+3.16'
    'G#-1+1.4'
    'G#-1+5.16'
    'G#-1+3.8'
    'G#-1+7.16'
    'A-1'
    'A-1+1.16'
    'A-1+1.8'
    'A-1+3.16'
    'A-1+1.4'
    'A-1+5.16'
    'A-1+3.8'
    'A-1+7.16'
    'A#-1'
    'A#-1+1.16'
    'A#-1+1.8'
    'A#-1+3.16'
    'A#-1+1.4'
    'A#-1+5.16'
    'A#-1+3.8'
    'A#-1+7.16'
    'B-1'
    'B-1+1.16'
    'B-1+1.8'
    'B-1+3.16'
    'B-1+1.4'
    'B-1+5.16'
    'B-1+3.8'
    'B-1+7.16'
    'C0'
    'C0+1.16'
    'C0+1.8'
    'C0+3.16'
    'C0+1.4'
    'C0+5.16'
    'C0+3.8'
    'C0+7.16'
    'C#0'
    'C#0+1.16'
    'C#0+1.8'
    'C#0+3.16'
    'C#0+1.4'
    'C#0+5.16'
    'C#0+3.8'
    'C#0+7.16'
    'D0'
    'D0+1.16'
    'D0+1.8'
    'D0+3.16'
    'D0+1.4'
    'D0+5.16'
    'D0+3.8'
    'D0+7.16'
    'D#0'
    'D#0+1.16'
    'D#0+1.8'
    'D#0+3.16'
    'D#0+1.4'
    'D#0+5.16'
    'D#0+3.8'
    'D#0+7.16'
    'E0'
    'E0+1.16'
    'E0+1.8'
    'E0+3.16'
    'E0+1.4'
    'E0+5.16'
    'E0+3.8'
    'E0+7.16'
    'F0'
    'F0+1.16'
    'F0+1.8'
    'F0+3.16'
    'F0+1.4'
    'F0+5.16'
    'F0+3.8'
    'F0+7.16'
    'F#0'
    'F#0+1.16'
    'F#0+1.8'
    'F#0+3.16'
    'F#0+1.4'
    'F#0+5.16'
    'F#0+3.8'
    'F#0+7.16'
    'G0'
    'G0+1.16'
    'G0+1.8'
    'G0+3.16'
    'G0+1.4'
    'G0+5.16'
    'G0+3.8'
    'G0+7.16'
    'G#0'
    'G#0+1.16'
    'G#0+1.8'
    'G#0+3.16'
    'G#0+1.4'
    'G#0+5.16'
    'G#0+3.8'
    'G#0+7.16'
    'A0'
    'A0+1.16'
    'A0+1.8'
    'A0+3.16'
    'A0+1.4'
    'A0+5.16'
    'A0+3.8'
    'A0+7.16'
    'A#0'
    'A#0+1.16'
    'A#0+1.8'
    'A#0+3.16'
    'A#0+1.4'
    'A#0+5.16'
    'A#0+3.8'
    'A#0+7.16'
    'B0'
    'B0+1.16'
    'B0+1.8'
    'B0+3.16'
    'B0+1.4'
    'B0+5.16'
    'B0+3.8'
    'B0+7.16'
    'C1'
    'C1+1.16'
    'C1+1.8'
    'C1+3.16'
    'C1+1.4'
    'C1+5.16'
    'C1+3.8'
    'C1+7.16'
    'C#1'
    'C#1+1.16'
    'C#1+1.8'
    'C#1+3.16'
    'C#1+1.4'
    'C#1+5.16'
    'C#1+3.8'
    'C#1+7.16'
    'D1'
    'D1+1.16'
    'D1+1.8'
    'D1+3.16'
    'D1+1.4'
    'D1+5.16'
    'D1+3.8'
    'D1+7.16'
    'D#1'
    'D#1+1.16'
    'D#1+1.8'
    'D#1+3.16'
    'D#1+1.4'
    'D#1+5.16'
    'D#1+3.8'
    'D#1+7.16'
    'E1'
    'E1+1.16'
    'E1+1.8'
    'E1+3.16'
    'E1+1.4'
    'E1+5.16'
    'E1+3.8'
    'E1+7.16'
    'F1'
    'F1+1.16'
    'F1+1.8'
    'F1+3.16'
    'F1+1.4'
    'F1+5.16'
    'F1+3.8'
    'F1+7.16'
    'F#1'
    'F#1+1.16'
    'F#1+1.8'
    'F#1+3.16'
    'F#1+1.4'
    'F#1+5.16'
    'F#1+3.8'
    'F#1+7.16'
    'G1'
    'G1+1.16'
    'G1+1.8'
    'G1+3.16'
    'G1+1.4'
    'G1+5.16'
    'G1+3.8'
    'G1+7.16'
    'G#1'
    'G#1+1.16'
    'G#1+1.8'
    'G#1+3.16'
    'G#1+1.4'
    'G#1+5.16'
    'G#1+3.8'
    'G#1+7.16'
    'A1'
    'A1+1.16'
    'A1+1.8'
    'A1+3.16'
    'A1+1.4'
    'A1+5.16'
    'A1+3.8'
    'A1+7.16'
    'A#1'
    'A#1+1.16'
    'A#1+1.8'
    'A#1+3.16'
    'A#1+1.4'
    'A#1+5.16'
    'A#1+3.8'
    'A#1+7.16'
    'B1'
    'B1+1.16'
    'B1+1.8'
    'B1+3.16'
    'B1+1.4'
    'B1+5.16'
    'B1+3.8'
    'B1+7.16'
    'C2'
    'C2+1.16'
    'C2+1.8'
    'C2+3.16'
    'C2+1.4'
    'C2+5.16'
    'C2+3.8'
    'C2+7.16'
    'C#2'
    'C#2+1.16'
    'C#2+1.8'
    'C#2+3.16'
    'C#2+1.4'
    'C#2+5.16'
    'C#2+3.8'
    'C#2+7.16'
    'D2'
    'D2+1.16'
    'D2+1.8'
    'D2+3.16'
    'D2+1.4'
    'D2+5.16'
    'D2+3.8'
    'D2+7.16'
    'D#2'
    'D#2+1.16'
    'D#2+1.8'
    'D#2+3.16'
    'D#2+1.4'
    'D#2+5.16'
    'D#2+3.8'
    'D#2+7.16'
    'E2'
    'E2+1.16'
    'E2+1.8'
    'E2+3.16'
    'E2+1.4'
    'E2+5.16'
    'E2+3.8'
    'E2+7.16'
    'F2'
    'F2+1.16'
    'F2+1.8'
    'F2+3.16'
    'F2+1.4'
    'F2+5.16'
    'F2+3.8'
    'F2+7.16'
    'F#2'
    'F#2+1.16'
    'F#2+1.8'
    'F#2+3.16'
    'F#2+1.4'
    'F#2+5.16'
    'F#2+3.8'
    'F#2+7.16'
    'G2'
    'G2+1.16'
    'G2+1.8'
    'G2+3.16'
    'G2+1.4'
    'G2+5.16'
    'G2+3.8'
    'G2+7.16'
    'G#2'
    'G#2+1.16'
    'G#2+1.8'
    'G#2+3.16'
    'G#2+1.4'
    'G#2+5.16'
    'G#2+3.8'
    'G#2+7.16'
    'A2'
    'A2+1.16'
    'A2+1.8'
    'A2+3.16'
    'A2+1.4'
    'A2+5.16'
    'A2+3.8'
    'A2+7.16'
    'A#2'
    'A#2+1.16'
    'A#2+1.8'
    'A#2+3.16'
    'A#2+1.4'
    'A#2+5.16'
    'A#2+3.8'
    'A#2+7.16'
    'B2'
    'B2+1.16'
    'B2+1.8'
    'B2+3.16'
    'B2+1.4'
    'B2+5.16'
    'B2+3.8'
    'B2+7.16'
    'C3'
    'C3+1.16'
    'C3+1.8'
    'C3+3.16'
    'C3+1.4'
    'C3+5.16'
    'C3+3.8'
    'C3+7.16'
    'C#3'
    'C#3+1.16'
    'C#3+1.8'
    'C#3+3.16'
    'C#3+1.4'
    'C#3+5.16'
    'C#3+3.8'
    'C#3+7.16'
    'D3'
    'D3+1.16'
    'D3+1.8'
    'D3+3.16'
    'D3+1.4'
    'D3+5.16'
    'D3+3.8'
    'D3+7.16'
    'D#3'
    'D#3+1.16'
    'D#3+1.8'
    'D#3+3.16'
    'D#3+1.4'
    'D#3+5.16'
    'D#3+3.8'
    'D#3+7.16'
    'E3'
    'E3+1.16'
    'E3+1.8'
    'E3+3.16'
    'E3+1.4'
    'E3+5.16'
    'E3+3.8'
    'E3+7.16'
    'F3'
    'F3+1.16'
    'F3+1.8'
    'F3+3.16'
    'F3+1.4'
    'F3+5.16'
    'F3+3.8'
    'F3+7.16'
    'F#3'
    'F#3+1.16'
    'F#3+1.8'
    'F#3+3.16'
    'F#3+1.4'
    'F#3+5.16'
    'F#3+3.8'
    'F#3+7.16'
    'G3'
    'G3+1.16'
    'G3+1.8'
    'G3+3.16'
    'G3+1.4'
    'G3+5.16'
    'G3+3.8'
    'G3+7.16'
    'G#3'
    'G#3+1.16'
    'G#3+1.8'
    'G#3+3.16'
    'G#3+1.4'
    'G#3+5.16'
    'G#3+3.8'
    'G#3+7.16'
    'A3'
    'A3+1.16'
    'A3+1.8'
    'A3+3.16'
    'A3+1.4'
    'A3+5.16'
    'A3+3.8'
    'A3+7.16'
    'A#3'
    'A#3+1.16'
    'A#3+1.8'
    'A#3+3.16'
    'A#3+1.4'
    'A#3+5.16'
    'A#3+3.8'
    'A#3+7.16'
    'B3'
    'B3+1.16'
    'B3+1.8'
    'B3+3.16'
    'B3+1.4'
    'B3+5.16'
    'B3+3.8'
    'B3+7.16'
    'C4'
    'C4+1.16'
    'C4+1.8'
    'C4+3.16'
    'C4+1.4'
    'C4+5.16'
    'C4+3.8'
    'C4+7.16'
    'C#4'
    'C#4+1.16'
    'C#4+1.8'
    'C#4+3.16'
    'C#4+1.4'
    'C#4+5.16'
    'C#4+3.8'
    'C#4+7.16'
    'D4'
    'D4+1.16'
    'D4+1.8'
    'D4+3.16'
    'D4+1.4'
    'D4+5.16'
    'D4+3.8'
    'D4+7.16'
    'D#4'
    'D#4+1.16'
    'D#4+1.8'
    'D#4+3.16'
    'D#4+1.4'
    'D#4+5.16'
    'D#4+3.8'
    'D#4+7.16'
    'E4'
    'E4+1.16'
    'E4+1.8'
    'E4+3.16'
    'E4+1.4'
    'E4+5.16'
    'E4+3.8'
    'E4+7.16'
    'F4'
    'F4+1.16'
    'F4+1.8'
    'F4+3.16'
    'F4+1.4'
    'F4+5.16'
    'F4+3.8'
    'F4+7.16'
    'F#4'
    'F#4+1.16'
    'F#4+1.8'
    'F#4+3.16'
    'F#4+1.4'
    'F#4+5.16'
    'F#4+3.8'
    'F#4+7.16'
    'G4'
    'G4+1.16'
    'G4+1.8'
    'G4+3.16'
    'G4+1.4'
    'G4+5.16'
    'G4+3.8'
    'G4+7.16'
    'G#4'
    'G#4+1.16'
    'G#4+1.8'
    'G#4+3.16'
    'G#4+1.4'
    'G#4+5.16'
    'G#4+3.8'
    'G#4+7.16'
    'A4'
    'A4+1.16'
    'A4+1.8'
    'A4+3.16'
    'A4+1.4'
    'A4+5.16'
    'A4+3.8'
    'A4+7.16'
    'A#4'
    'A#4+1.16'
    'A#4+1.8'
    'A#4+3.16'
    'A#4+1.4'
    'A#4+5.16'
    'A#4+3.8'
    'A#4+7.16'
    'B4'
    'B4+1.16'
    'B4+1.8'
    'B4+3.16'
    'B4+1.4'
    'B4+5.16'
    'B4+3.8'
    'B4+7.16'
    'C5'
    'C5+1.16'
    'C5+1.8'
    'C5+3.16'
    'C5+1.4'
    'C5+5.16'
    'C5+3.8'
    'C5+7.16'
    'C#5'
    'C#5+1.16'
    'C#5+1.8'
    'C#5+3.16'
    'C#5+1.4'
    'C#5+5.16'
    'C#5+3.8'
    'C#5+7.16'
    'D5'
    'D5+1.16'
    'D5+1.8'
    'D5+3.16'
    'D5+1.4'
    'D5+5.16'
    'D5+3.8'
    'D5+7.16'
    'D#5'
    'D#5+1.16'
    'D#5+1.8'
    'D#5+3.16'
    'D#5+1.4'
    'D#5+5.16'
    'D#5+3.8'
    'D#5+7.16'
    'E5'
    'E5+1.16'
    'E5+1.8'
    'E5+3.16'
    'E5+1.4'
    'E5+5.16'
    'E5+3.8'
    'E5+7.16'
    'F5'
    'F5+1.16'
    'F5+1.8'
    'F5+3.16'
    'F5+1.4'
    'F5+5.16'
    'F5+3.8'
    'F5+7.16'
    'F#5'
    'F#5+1.16'
    'F#5+1.8'
    'F#5+3.16'
    'F#5+1.4'
    'F#5+5.16'
    'F#5+3.8'
    'F#5+7.16'
    'G5'
    'G5+1.16'
    'G5+1.8'
    'G5+3.16'
    'G5+1.4'
    'G5+5.16'
    'G5+3.8'
    'G5+7.16'
    'G#5'
    'G#5+1.16'
    'G#5+1.8'
    'G#5+3.16'
    'G#5+1.4'
    'G#5+5.16'
    'G#5+3.8'
    'G#5+7.16'
    'A5'
    'A5+1.16'
    'A5+1.8'
    'A5+3.16'
    'A5+1.4'
    'A5+5.16'
    'A5+3.8'
    'A5+7.16'
    'A#5'
    'A#5+1.16'
    'A#5+1.8'
    'A#5+3.16'
    'A#5+1.4'
    'A#5+5.16'
    'A#5+3.8'
    'A#5+7.16'
    'B5'
    'B5+1.16'
    'B5+1.8'
    'B5+3.16'
    'B5+1.4'
    'B5+5.16'
    'B5+3.8'
    'B5+7.16'
    'C6'
    'C6+1.16'
    'C6+1.8'
    'C6+3.16'
    'C6+1.4'
    'C6+5.16'
    'C6+3.8'
    'C6+7.16'
    'C#6'
    'C#6+1.16'
    'C#6+1.8'
    'C#6+3.16'
    'C#6+1.4'
    'C#6+5.16'
    'C#6+3.8'
    'C#6+7.16'
    'D6'
    'D6+1.16'
    'D6+1.8'
    'D6+3.16'
    'D6+1.4'
    'D6+5.16'
    'D6+3.8'
    'D6+7.16'
    'D#6'
    'D#6+1.16'
    'D#6+1.8'
    'D#6+3.16'
    'D#6+1.4'
    'D#6+5.16'
    'D#6+3.8'
    'D#6+7.16'
    'E6'
    'E6+1.16'
    'E6+1.8'
    'E6+3.16'
    'E6+1.4'
    'E6+5.16'
    'E6+3.8'
    'E6+7.16'
    'F6'
    'F6+1.16'
    'F6+1.8'
    'F6+3.16'
    'F6+1.4'
    'F6+5.16'
    'F6+3.8'
    'F6+7.16'
    'F#6'
    'F#6+1.16'
    'F#6+1.8'
    'F#6+3.16'
    'F#6+1.4'
    'F#6+5.16'
    'F#6+3.8'
    'F#6+7.16'
    'G6'
    'G6+1.16'
    'G6+1.8'
    'G6+3.16'
    'G6+1.4'
    'G6+5.16'
    'G6+3.8'
    'G6+7.16'
    'G#6'
    'G#6+1.16'
    'G#6+1.8'
    'G#6+3.16'
    'G#6+1.4'
    'G#6+5.16'
    'G#6+3.8'
    'G#6+7.16'
    'A6'
    'A6+1.16'
    'A6+1.8'
    'A6+3.16'
    'A6+1.4'
    'A6+5.16'
    'A6+3.8'
    'A6+7.16'
    'A#6'
    'A#6+1.16'
    'A#6+1.8'
    'A#6+3.16'
    'A#6+1.4'
    'A#6+5.16'
    'A#6+3.8'
    'A#6+7.16'
    'B6'
    'B6+1.16'
    'B6+1.8'
    'B6+3.16'
    'B6+1.4'
    'B6+5.16'
    'B6+3.8'
    'B6+7.16'
    'C7'
    'C7+1.16'
    'C7+1.8'
    'C7+3.16'
    'C7+1.4'
    'C7+5.16'
    'C7+3.8'
    'C7+7.16'
    'C#7'
    'C#7+1.16'
    'C#7+1.8'
    'C#7+3.16'
    'C#7+1.4'
    'C#7+5.16'
    'C#7+3.8'
    'C#7+7.16'
    'D7'
    'D7+1.16'
    'D7+1.8'
    'D7+3.16'
    'D7+1.4'
    'D7+5.16'
    'D7+3.8'
    'D7+7.16'
    'D#7'
    'D#7+1.16'
    'D#7+1.8'
    'D#7+3.16'
    'D#7+1.4'
    'D#7+5.16'
    'D#7+3.8'
    'D#7+7.16'
    'E7'
    'E7+1.16'
    'E7+1.8'
    'E7+3.16'
    'E7+1.4'
    'E7+5.16'
    'E7+3.8'
    'E7+7.16'
    'F7'
    'F7+1.16'
    'F7+1.8'
    'F7+3.16'
    'F7+1.4'
    'F7+5.16'
    'F7+3.8'
    'F7+7.16'
    'F#7'
    'F#7+1.16'
    'F#7+1.8'
    'F#7+3.16'
    'F#7+1.4'
    'F#7+5.16'
    'F#7+3.8'
    'F#7+7.16'
    'G7'
    'G7+1.16'
    'G7+1.8'
    'G7+3.16'
    'G7+1.4'
    'G7+5.16'
    'G7+3.8'
    'G7+7.16'
    'G#7'
    'G#7+1.16'
    'G#7+1.8'
    'G#7+3.16'
    'G#7+1.4'
    'G#7+5.16'
    'G#7+3.8'
    'G#7+7.16'
    'A7'
    'A7+1.16'
    'A7+1.8'
    'A7+3.16'
    'A7+1.4'
    'A7+5.16'
    'A7+3.8'
    'A7+7.16'
    'A#7'
    'A#7+1.16'
    'A#7+1.8'
    'A#7+3.16'
    'A#7+1.4'
    'A#7+5.16'
    'A#7+3.8'
    'A#7+7.16'
    'B7'
    'B7+1.16'
    'B7+1.8'
    'B7+3.16'
    'B7+1.4'
    'B7+5.16'
    'B7+3.8'
    'B7+7.16'
    'C8'
    'C8+1.16'
    'C8+1.8'
    'C8+3.16'
    'C8+1.4'
    'C8+5.16'
    'C8+3.8'
    'C8+7.16'
    'C#8'
    'C#8+1.16'
    'C#8+1.8'
    'C#8+3.16'
    'C#8+1.4'
    'C#8+5.16'
    'C#8+3.8'
    'C#8+7.16'
    'D8'
    'D8+1.16'
    'D8+1.8'
    'D8+3.16'
    'D8+1.4'
    'D8+5.16'
    'D8+3.8'
    'D8+7.16'
    'D#8'
    'D#8+1.16'
    'D#8+1.8'
    'D#8+3.16'
    'D#8+1.4'
    'D#8+5.16'
    'D#8+3.8'
    'D#8+7.16'
    'E8'
    'E8+1.16'
    'E8+1.8'
    'E8+3.16'
    'E8+1.4'
    'E8+5.16'
    'E8+3.8'
    'E8+7.16'
    'F8'
    'F8+1.16'
    'F8+1.8'
    'F8+3.16'
    'F8+1.4'
    'F8+5.16'
    'F8+3.8'
    'F8+7.16'
    'F#8'
    'F#8+1.16'
    'F#8+1.8'
    'F#8+3.16'
    'F#8+1.4'
    'F#8+5.16'
    'F#8+3.8'
    'F#8+7.16'
    'G8'
    'G8+1.16'
    'G8+1.8'
    'G8+3.16'
    'G8+1.4'
    'G8+5.16'
    'G8+3.8'
    'G8+7.16'
    'G#8'
    'G#8+1.16'
    'G#8+1.8'
    'G#8+3.16'
    'G#8+1.4'
    'G#8+5.16'
    'G#8+3.8'
    'G#8+7.16'
    'A8'
    'A8+1.16'
    'A8+1.8'
    'A8+3.16'
    'A8+1.4'
    'A8+5.16'
    'A8+3.8'
    'A8+7.16'
    'A#8'
    'A#8+1.16'
    'A#8+1.8'
    'A#8+3.16'
    'A#8+1.4'
    'A#8+5.16'
    'A#8+3.8'
    'A#8+7.16'
    'B8'
    'B8+1.16'
    'B8+1.8'
    'B8+3.16'
    'B8+1.4'
    'B8+5.16'
    'B8+3.8'
    'B8+7.16'
    'C9'
    'C9+1.16'
    'C9+1.8'
    'C9+3.16'
    'C9+1.4'
    'C9+5.16'
    'C9+3.8'
    'C9+7.16'
    'C#9'
    'C#9+1.16'
    'C#9+1.8'
    'C#9+3.16'
    'C#9+1.4'
    'C#9+5.16'
    'C#9+3.8'
    'C#9+7.16'
    'D9'
    'D9+1.16'
    'D9+1.8'
    'D9+3.16'
    'D9+1.4'
    'D9+5.16'
    'D9+3.8'
    'D9+7.16'
    'D#9'
    'D#9+1.16'
    'D#9+1.8'
    'D#9+3.16'
    'D#9+1.4'
    'D#9+5.16'
    'D#9+3.8'
    'D#9+7.16'
    'E9'
    'E9+1.16'
    'E9+1.8'
    'E9+3.16'
    'E9+1.4'
    'E9+5.16'
    'E9+3.8'
    'E9+7.16'
    'F9'
    'F9+1.16'
    'F9+1.8'
    'F9+3.16'
    'F9+1.4'
    'F9+5.16'
    'F9+3.8'
    'F9+7.16'
    'F#9'
    'F#9+1.16'
    'F#9+1.8'
    'F#9+3.16'
    'F#9+1.4'
    'F#9+5.16'
    'F#9+3.8'
    'F#9+7.16'
    'G9'
    'G9+1.16'
    'G9+1.8'
    'G9+3.16'
    'G9+1.4'
    'G9+5.16'
    'G9+3.8'
    'G9+7.16' };

% The conversion is here
all_mt_midi = (0:1/8:127+7/8)';
[T,I] = ismember(mtmidi,all_mt_midi);
I = I(I > 0);
mtnotes = all_mt_notes(I);

